#!/usr/bin/python3
#-----------------------------------------------------------------------------
# Copyright (C) 2016 Correlated Solutions, Inc. All rights reserved.
#
# This program illustrates how to invoke the strain computation algorithm
# for Vic-3D data sets in python.
#-----------------------------------------------------------------------------

from VicPy import * 

from os import _exit as exit
import sys


if len(sys.argv) != 3:
    print("Usage: %s infile.out outfile.out\n" % sys.argv[0])
    exit(-1)

data = VicDataSet()
if data.load(sys.argv[1]) == False:
    print("Could not load the dataset\n\n")
    exit(-1)

# Strain computation options:
#   tensorType: "lagrange", "hencky", "euler", "log_euler", "engineering", "biot"
#   windowSize: must be odd, minimum size is 3
#   other options self explanatory

ret = data.computeStrain(tensorType = "hencky", windowSize = 7, outputGradient = False,
                             computePrincipalStrain = True, reuseVars = True,
                             weightedFilter = True, computeTresca = False, computeVonMises = False)
if ret == False:
    print("Strain computation failed.\n")
    exit(-1)

if data.save(sys.argv[2]) == False:
    print("Could not save the dataset\n\n")
    exit(-1)
