import VicPy
import os
import socket
import sys
import numpy as np
import scipy.io as sio


def run_rt_client(host, port):
    # connect to rt_server
    client_socket = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    client_socket.connect((host, port))
    # send message to server to start data streaming
    client_socket.send('S'.encode('utf-8'))

    message_length = 0
    message_type = 0
    all_data = bytearray()
    header_length = 8
    data_set_i = 0

    # keep reading data from socket
    while True:
        data = client_socket.recv(1000000)
        all_data += data
        # We can receive more than one number of data sets, so process all the received messages
        while True:
            # check is header was processed
            if message_length == 0:
                if len(all_data) >= header_length:
                    # data header is received, so message type and message length can be obtained
                    message_type = int.from_bytes(all_data[0:4], byteorder=sys.byteorder)
                    message_length = int.from_bytes(all_data[4:8], byteorder=sys.byteorder) + header_length

            # if header is not processed, break
            if message_length == 0:
                break

            # if not entire message is read, break
            if message_length > len(all_data):
                break

            # process received message
            message = all_data[header_length:message_length]
            all_data = all_data[message_length:]

            process_data(message, message_type, data_set_i)
            data_set_i += 1


def process_data(message, message_type, data_set_i):
    # data set message
    if message_type == 0x00000003:
        print("Data set #", data_set_i, "received")
        # save received data in Vic format
        filename = "data" + str(data_set_i) + ".out"
        # save data set in Vic3D format
        new_file = open(filename, "wb")
        new_file.write(message)
        new_file.close()
        data = VicPy.VicDataSet()
        # load data set from the memory
        data.loadFromData(message)
        # export data into matlab file
        data.exportMatV4(str(data_set_i) + ".mat")

    # error message, show it and exit
    elif message_type == 0x00000000:
        print(message.decode("utf-8"))
        sys.exit(-1)

    else:
        print("Unknown message type, exiting.")
        sys.exit(-1)


if __name__ == '__main__':
    host = 'localhost'
    port = 20020

    if len(sys.argv) > 3:
        print("Usage: " + sys.argv[0] + " host port", file=sys.stderr)
        sys.exit(-1)

    if len(sys.argv) == 2:
        host = sys.argv[1]

    if len(sys.argv) == 3:
        host = sys.argv[1]
        port = int(sys.argv[2])

    print("Using host: " + host + "\n and port: " + str(port))
    print("To exit, press Ctrl-C")
    run_rt_client(host, port)
