#!/usr/bin/python3
#-----------------------------------------------------------------------------
# Copyright (C) 2016 Correlated Solutions, Inc. All rights reserved.
#
# This program illustrates how to invoke the curvature computation algorithm
# for Vic-3D data sets in python.
#-----------------------------------------------------------------------------

from VicPy import * 
import sys


if len(sys.argv) != 3:
    sys.exit('Usage: %s infile.out outfile.out\n' % sys.argv[0])

data = VicDataSet()
if data.load(sys.argv[1]) == False:
    sys.exit('Could not load the dataset.')

# Curvature computation options:
#   windowSize: must be odd, minimum size is 3
#   other options self explanatory

ret = data.computeCurvature(windowSize = 15, computePrincipalCurvature = True, reuseVars = True, 
        weightedFilter = True)
if ret == False:
    sys.exit('Curvature computation failed.')

if data.save(sys.argv[2]) == False:
    sys.exit('Could not save the dataset.')

