#!/usr/bin/env python3
#-----------------------------------------------------------------------------
# Copyright (C) 2017 Correlated Solutions, Inc.
#
# Permission to use, copy, modify, and/or distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.
# 
# THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
# REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
# AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
# INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
# LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
# OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
# PERFORMANCE OF THIS SOFTWARE.
#-----------------------------------------------------------------------------
# This program illustrates how to read a Vic-3D data file and convert
# it to a csv file.
#-----------------------------------------------------------------------------

from VicPy import *

import time
from io import open
from os import _exit as exit
import sys
t0 = time.time()

data = VicDataSet()
if(len(sys.argv) != 3):
    print("Usage: %s infile.out outfile.csv\n" % sys.argv[0])
    exit(-1)
    
if (data.load(sys.argv[1]) == False):
    print("Could not load data set\n\n")
    exit(-1)
try:
    out = open(sys.argv[2], "w", encoding="utf-8")
except:
    print("Could not open output file\n\n")
    exit(-1)

# List of variables that will be exported
var_names = ["X", "Y", "Z", "U", "V", "W"]

# Prepend sigma to export list for convinience. This
# will not be exported and is just used for a validity
# check.
var_names.insert(0, "sigma")

for aoi in range(data.numData()):
    d = data.data(aoi)
    var_ids = []
    for var in var_names:
        idx = d.varIndex(var)
        if (idx < 0):
            print("Could not find variable %s" % var)
        else:
            var_ids.append(idx)
            if var != "sigma":
                name = d.varDescription(idx);
                if len(var_ids) > 2:
                    out.write(",")
                # write the column names to the output file
                out.write("\"" + name + "\"") 
            
    out.write("\n")

    for i in range(d.matrixSize()):
        v = d.values(i, var_ids)
        if v[0] < 0:
            continue
        for j in range(1, len(v)):
            if j > 1:
                out.write(",")
            out.write(str(v[j]))
        out.write("\n")

out.close()
t1 = time.time()
print("Time for data export: {0:.3f} seconds.\n".format(t1-t0))
