#!/usr/bin/env python3
#-----------------------------------------------------------------------------
# Copyright (C) 2017 Correlated Solutions, Inc.
#
# Permission to use, copy, modify, and/or distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.
# 
# THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
# REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
# AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
# INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
# LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
# OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
# PERFORMANCE OF THIS SOFTWARE.
#-----------------------------------------------------------------------------
# This program illustrates how to read a Vic data file, compute the displacement 
# magnitude D=sqrt(U^2+V^2+W^2) at every point and save a new data file that
# contains the resultant displacement as a new variable.
#-----------------------------------------------------------------------------

from VicPy import *

import math
import time
from os import _exit as exit
import sys
t0 = time.time()

data = VicDataSet()
if len(sys.argv) != 3:
    print("Usage: %s infile.out outfile.out\n" % sys.argv[0])
    exit(-1)
    
if (data.load(sys.argv[1]) == False):
    print("Could not load data set\n\n")
    exit(-1)

# The add variable function returns the actual name
# of the variable, which might be different from the
# requested name if the variable already exists.
#
r_var = data.addVariable("D", "Δ [mm]")

var_names = ["sigma", "U", "V", "W"]
aoi = 0
for aoi in range(data.numData()):
    d = data.data(aoi)
    var_ids = []
    r_idx = d.varIndex(r_var);
    if r_idx < 0:
        print("Could not find variable index for resultant.")
        exit(-1)
    for var in var_names:
        idx = d.varIndex(var)
        if (idx < 0):
            print("Could not find variable %s" % var)
            exit(-1)
        var_ids.append(idx)
        
    for i in range(d.matrixSize()):
        values = d.values(i, var_ids)
        r = 0.0
        if values[0] >= 0:
            u = values[1]
            v = values[2]
            w = values[3]
            r = math.sqrt(u * u + v * v + w * w)
        d.setValue(i, r_idx, r)

if data.save(sys.argv[2]) == False:
    print("Could not save the dataset\n\n")
    exit(-1)
        
t1 = time.time()
print("Time for computing resultant: {0:.3f} seconds.\n".format(t1-t0))
